unit MyMath1V1;
//=============================================================================
//       .
//          DELPHI
//  (c)  ..  2.1.  16.02.2012.
//=============================================================================
//     INTERFACE
//=============================================================================
interface

uses SysUtils;

//    
const CoeffMaxNum = 63;
//     SIN  
const SinCoeff : array [0..CoeffMaxNum] of double =
 ( 0,    1,   0,   -1,    0,   1,    0,   -1,
   0,    1,   0,   -1,    0,   1,    0,   -1,
   0,    1,   0,   -1,    0,   1,    0,   -1,
   0,    1,   0,   -1,    0,   1,    0,   -1,
   0,    1,   0,   -1,    0,   1,    0,   -1,
   0,    1,   0,   -1,    0,   1,    0,   -1,
   0,    1,   0,   -1,    0,   1,    0,   -1,
   0,    1,   0,   -1,    0,   1,    0,   -1
 );

//     SI ( )  
const SiCoeff : array [0..CoeffMaxNum] of double =
 ( 0,  1,     0,  -1/3,   0,  1/5,   0,  -1/7,
   0,  1/9,   0,  -1/11,  0,  1/13,  0,  -1/15,
   0,  1/17,  0,  -1/19,  0,  1/21,  0,  -1/23,
   0,  1/25,  0,  -1/27,  0,  1/29,  0,  -1/31,
   0,  1/33,  0,  -1/35,  0,  1/37,  0,  -1/39,
   0,  1/41,  0,  -1/43,  0,  1/45,  0,  -1/47,
   0,  1/49,  0,  -1/51,  0,  1/53,  0,  -1/55,
   0,  1/57,  0,  -1/59,  0,  1/61,  0,  -1/63
 );

//     SinC = Sin(X)/X  
const SinCCoeff : array [0..CoeffMaxNum] of double =
 ( 1,     0,  -1/3,   0,  1/5,   0,  -1/7,   0,
   1/9,   0,  -1/11,  0,  1/13,  0,  -1/15,  0,
   1/17,  0,  -1/19,  0,  1/21,  0,  -1/23,  0,
   1/25,  0,  -1/27,  0,  1/29,  0,  -1/31,  0,
   1/33,  0,  -1/35,  0,  1/37,  0,  -1/39,  0,
   1/41,  0,  -1/43,  0,  1/45,  0,  -1/47,  0,
   1/49,  0,  -1/51,  0,  1/53,  0,  -1/55,  0,
   1/57,  0,  -1/59,  0,  1/61,  0,  -1/63,  0
 );

//     Sh ( )  
const ShCoeff : array [0..CoeffMaxNum] of double =
 ( 0,     1,   0,    1,    0,    1,    0,    1,
   0,     1,   0,    1,    0,    1,    0,    1,
   0,     1,   0,    1,    0,    1,    0,    1,
   0,     1,   0,    1,    0,    1,    0,    1,
   0,     1,   0,    1,    0,    1,    0,    1,
   0,     1,   0,    1,    0,    1,    0,    1,
   0,     1,   0,    1,    0,    1,    0,    1,
   0,     1,   0,    1,    0,    1,    0,    1
 );

//     COS  
const CosCoeff : array [0..CoeffMaxNum] of double =
 ( 1,     0,  -1,    0,    1,    0,    -1,   0,
   1,     0,  -1,    0,    1,    0,    -1,   0,
   1,     0,  -1,    0,    1,    0,    -1,   0,
   1,     0,  -1,    0,    1,    0,    -1,   0,
   1,     0,  -1,    0,    1,    0,    -1,   0,
   1,     0,  -1,    0,    1,    0,    -1,   0,
   1,     0,  -1,    0,    1,    0,    -1,   0,
   1,     0,  -1,    0,    1,    0,    -1,   0
 );

//     Ch ( )  
const ChCoeff : array [0..CoeffMaxNum] of double =
 ( 1,     0,   1,    0,    1,    0,     1,   0,
   1,     0,   1,    0,    1,    0,     1,   0,
   1,     0,   1,    0,    1,    0,     1,   0,
   1,     0,   1,    0,    1,    0,     1,   0,
   1,     0,   1,    0,    1,    0,     1,   0,
   1,     0,   1,    0,    1,    0,     1,   0,
   1,     0,   1,    0,    1,    0,     1,   0,
   1,     0,   1,    0,    1,    0,     1,   0
 );

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

//     
procedure InitLastValue (RqVal : extended);
// ----------------------------------------------------------------------------
//       
// RqCoeff -      
// RqX  -  
function Tailor (RqCoeff : array of double; RqX : double) : extended;
// ----------------------------------------------------------------------------

//=============================================================================
//     IMPLEMENTATION
//=============================================================================
implementation

var LastValue : extended;    //    

// ----------------------------------------------------------------------------
//     
procedure InitLastValue (RqVal : extended);
begin
  LastValue := RqVal;
end;
// ----------------------------------------------------------------------------
//       
// RqCoeff -      
// RqX  -  
function Tailor (RqCoeff : array of double; RqX : double) : extended;
var Ind  : integer;         //  
    Fn   : integer;         //    
    Elm  : extended;        //  
begin
    Result    := 0;         //    
    Fn        := 1;         //     
    Elm       := 1;         //    
    try
      for Ind := Low(RqCoeff) to High(RqCoeff)
      do begin
        if Abs(RqCoeff[Ind]) > 0 then Result := Result + RqCoeff[Ind] * Elm;
        Elm := Elm * (RqX / Fn);
        Inc(Fn);
      end;
      LastValue := Result;   //    
    except
      Result := LastValue;   //    
      Beep;
    end;
end;



// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

end.
